<?php
class Video_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('video_model');
    }

    // Función para obtener el video basado en el ID
    public function obtenerVideo($idvideo)
    {
        $this->db->select('*')->from('video')->where('id =', $idvideo);

        $video = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $video,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
        
        
    }


    // Función para actualizar el video
    public function actualizarVideo($video)
    {
        $id = $video["id"];
        $url      = $video["url"];

        // Creando el array con los datos básicos del usuario
        $video = array(
            'id'     => $id,
            'url'    => $url,
        );

        //Iniciando la transacción
        $this->db->trans_begin();

        // Actualizando la tabla de usuarios
        $this->db->set($video);
        $this->db->where('id', $id);
        $this->db->update('video');

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al actualizar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'respuesta' => 'Video actualizado correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'video');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
}