<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Noticias extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('noticias_model');
    }

    // Obtener el paginador
    public function noticiaspag_post()
    {
        $this->load->model('noticias_model');
        $respuesta = $this->noticias_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Funcin para actualizar la noticia
     public function actualizar_noticia_post()
     {
        $post = (array) json_decode($this->post('form'));
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->noticias_model->actualizarNoticia($post);
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Funcin para obtener la lista de los tipos de usuarios
    public function noticia_get($idnoticia = 0)
    {
        // Devolviendo los usuarios con un codigo 200 HTTP_OK
        $respuesta = $this->noticias_model->obtenerNoticia($idnoticia);
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Funcin para actualizar
    public function cambiar_orden_post()
    {
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->noticias_model->cambiar_orden($this->post());

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

    // Funcin para eliminar
    public function eliminar_noticia_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->noticias_model->eliminarNoticia($post);

       $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Funcin para agregar la noticia
    public function index_post()
    {
       $post = (array) json_decode($this->post('form'));
       // Obteniendo la respuesta de la funcion
       $respuesta = $this->noticias_model->agregarNoticia($post);

       $this->response($respuesta["mensaje"], $respuesta["status"]);
    }

}