<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Video extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('video_model');
    }

    public function index_post()
    {
                
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->video_model->guardarVideo($this->post());

        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function videopag_post()
    {
        $this->load->model('video_model');
        $respuesta = $this->video_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar
     public function index_put()
     {
 
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->video_model->actualizarVideo($this->put());
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     // Función para obtener la lista de los tipos de videos
    public function video_get($idvideo = 0)
    {

        if ($idvideo != 0)
        {
             // Devolviendo los videos con un codigo 200 HTTP_OK
            $respuesta = $this->video_model->obtenervideo($idvideo);
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }

        else
        {
            // Devolviendo el video con un codigo 200 HTTP_OK
            $respuesta = $this->video_model->obtenervideo();
            $this->response($respuesta["respuesta"], $respuesta["status"]);
        }
    }

}