<?php
defined('BASEPATH') or exit('No direct script access allowed');
require APPPATH . '/libraries/REST_Controller.php';
require APPPATH . '/helpers/jwt_helper.php';
include APPPATH . '/third_party/jwt/JWT.php';
include APPPATH . '/third_party/jwt/BeforeValidException.php';
include APPPATH . '/third_party/jwt/ExpiredException.php';
include APPPATH . '/third_party/jwt/SignatureInvalidException.php';

use Firebase\JWT\JWT;

class Infopagina extends REST_Controller
{
    public function __construct()
    {
        parent::__construct();
        $token = $this->input->get_request_header('Authorization', true);
        $token = Jwt_helper::verificarToken($token);

        if($token["status"] == 'HTTP_UNAUTHORIZED')
        {
             // Devolviendo el mensaje de error con un codigo 401 HTTP_UNAUTHORIZED
             $this->response($token["message"], REST_Controller::HTTP_UNAUTHORIZED);
        }
        $this->load->model('infopagina_model');
    }

    public function index_post()
    {
                
        // Devolviendo la respuesta con un codigo 200 HTTP_OK
        $respuesta = $this->infopagina_model->guardarInfopagina($this->post());

        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

    // Obtener el paginador
    public function infopaginaspag_post()
    {
        $this->load->model('infopagina_model');
        $respuesta = $this->infopagina_model->paginado($this->post());
        $this->response($respuesta["respuesta"], $respuesta["status"]);
    }

     // Función para actualizar
     public function index_put()
     {
 
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->infopagina_model->actualizarInfopagina($this->put());
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }

     public function cambiar_estado_put()
    {
        $this->load->model('infopagina_model');
        $respuesta = $this->infopagina_model->cambiar_estado($this->put());
        $status = $respuesta['status'];
        $this->response($respuesta, $status);
    }

     // Función para obtener la lista de los tipos de infopaginas
     public function infopagina_get($idinfopagina = 0)
     {
 
         if ($idinfopagina != 0)
         {
              // Devolviendo los infopaginas con un codigo 200 HTTP_OK
             $respuesta = $this->infopagina_model->obtenerInfopagina($idinfopagina);
             $this->response($respuesta["respuesta"], $respuesta["status"]);
         }
 
         else
         {
             // Devolviendo el infopagina con un codigo 200 HTTP_OK
             $respuesta = $this->infopagina_model->obtenerInfopagina();
             $this->response($respuesta["respuesta"], $respuesta["status"]);
         }
     }

     public function actualizar_imagen_post()
     {
        $post = (array) json_decode($this->post('form'));
        // Obteniendo la respuesta de la funcion
        $respuesta = $this->infopagina_model->actualizarImagen($post);
 
        $this->response($respuesta["respuesta"], $respuesta["status"]);
     }
}